IF  NOT EXISTS (SELECT * FROM sys.objects 
WHERE object_id = OBJECT_ID(N'[dbo].[INTEGRA_ECOMMERCE_PEDIDO]') AND type in (N'U'))
BEGIN

   CREATE TABLE [dbo].[INTEGRA_ECOMMERCE_PEDIDO](
	   [ID] [INT] IDENTITY(1,1) NOT NULL,
	[ECOMMERCE] [VARCHAR](20) NOT NULL,
	[CODIGO_PEDIDO] [VARCHAR](100) NOT NULL,
	[VALOR_PEDIDO] [MONEY] NOT NULL,
	[NOME_CLIENTE] [VARCHAR](255) NULL,
	[DATA_PEDIDO] [DATETIME] NOT NULL,
	[CODIGO_STATUS] [VARCHAR](20) NULL,
	[FALHOU] [BIT] NULL,
	[MENSAGEM_ERRO] [VARCHAR](1000) NULL,
	[CD_ORC] [INT] NULL,
	[DT_ORC] [DATETIME] NULL,
	[CD_ETAPA] [INT] NULL,
	[TIPO_ETAPA] [INT] NULL,
	[DTHR_ETAPA] [DATETIME] NULL,
	[OBS_ETAPA] [VARCHAR](255) NULL,
	[DT_ULT_ALT] [DATETIME] NULL,
	[FINALIZADO] [BIT] NULL,
	[JSON_PEDIDO] [TEXT] NULL,
	[IS_MARKET_PLACE] [TINYINT] NULL,
	[MARKET_PLACE_ORDER_ID] [VARCHAR](200) NULL,
	[PEND_ATUALIZACAO] [TINYINT] NULL,
	[NOME_MARKET_PLACE] [VARCHAR](200) NULL,
    CONSTRAINT [PK_INTEGRA_ECOMMERCE_PEDIDO] PRIMARY KEY CLUSTERED 
   (
	   [ECOMMERCE] ASC,
	   [CODIGO_PEDIDO] ASC
   )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
   ) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

END;


IF NOT EXISTS
(
   SELECT
      *
   FROM
      INFORMATION_SCHEMA.COLUMNS
   WHERE
      TABLE_NAME = 'INTEGRA_ECOMMERCE_PEDIDO' AND COLUMN_NAME = 'CODIGO_PEDIDO'
      AND CHARACTER_MAXIMUM_LENGTH = 100
)
BEGIN

   ALTER TABLE [dbo].[INTEGRA_ECOMMERCE_PEDIDO]
      ALTER COLUMN [CODIGO_PEDIDO] [varchar](100) NOT NULL

END;
    